<?php
include 'db.php';
include 'config.php';
?>
<!doctype html>
<html class="no-js" lang="en">

<!-- service-air.html  23:59:27 GMT -->

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo $sitename; ?> - <?php echo $site_title; ?></title>


    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta property="og:image" content="uploads/<?php echo $site_logo; ?>">

    <meta name="keywords" content=" <?php echo $sitename; ?> logistics, <?php echo $sitename; ?> transportation logistics, <?php echo $sitename; ?> logistics inc
        , <?php echo $sitename; ?> transportation logistics carrier setup, paramount transportation logistics services llc,uk based logistics companies, logistics companies uk, uk logistics companies
, largest uk logistics companies, <?php echo $sitename; ?> transportation logistics services ,<?php echo $sitename; ?> global logistics, <?php echo $sitename; ?> logistics fayetteville nc, revenant logistics inc paramount ca, <?php echo $sitename; ?> logistics courier, <?php echo $sitename; ?> logistics private limited, <?php echo $sitename; ?> logistics salem va, next generation logistics <?php echo $sitename; ?>,">


    <meta name="description" content="<?php echo $sitename; ?> Logistics is a premier logistics company offering global freight forwarding, transportation, and supply chain solutions. Our reliable and efficient services ensure on-time delivery, customized solutions, and exceptional customer satisfaction. Explore our expertise in international shipping, warehousing, and customs clearance.">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="uploads/<?php echo $site_logo; ?>">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/animate.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/fontawesome-all.min.css">
    <link rel="stylesheet" href="css/aos.css">
    <link rel="stylesheet" href="css/nice-select.css">
    <link rel="stylesheet" href="css/flaticon.css">
    <link rel="stylesheet" href="css/meanmenu.css">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/default.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- main-area -->
    <main>

        <!-- breadcrumb-area -->
        <div class="breadcrumb-area breadcrumb-bg s-breadcrumb-bg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="breadcrumb-content">
                            <nav aria-label="breadcrumb">
                                <ol class="breadcrumb">
                                    <li class="dots"></li>
                                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                                    <li class="breadcrumb-item active" aria-current="page">Ocean Freight</li>
                                    <li class="dots2"></li>
                                </ol>
                            </nav>
                            <h2>Ocean Freight</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- breadcrumb-area-end -->

        <!-- services-details -->
        <div class="services-details-area pt-120 pb-115">
            <div class="container">
                <div class="services-details-wrap">
                    <div class="row">
                        <div class="col-lg-4 order-2 order-lg-0">
                            <aside class="services-sidebar">
                                <div class="services-widget mb-40">
                                    <div class="service-widget-title">
                                        <h3>Service Category</h3>
                                    </div>
                                    <div class="service-cat-list">
                                        <ul>
                                            <li><a href="cargo-transportation">Cargo Transportation</a></li>
                                            <li><a href="air-freight">Air Freight</a></li>
                                            <li class="active"><a href="ocean-freight">Ocean Freight</a></li>
                                            <li><a href="packaging-and-storage">Packaging & Storage</a></li>
                                        </ul>
                                    </div>
                                </div>

                                <div class="services-widget mb-40">
                                    <div class="service-sidebar-support">
                                        <h3>Need Support?</h3>
                                        <p>We're always happy to help you out</p>
                                        <a href="contact" class="btn">contact Us</a>
                                    </div>
                                </div>

                            </aside>
                        </div>
                        <div class="col-lg-8">
                            <div class="services-details-content">
                                <img src="images/resource/fleet-4.jpg" style="width:100%;height:auto;margin-bottom:20px;" alt="">
                                <p>Introducing Ocean Freight Solutions by <?php echo $sitename; ?>: The Perfect Blend of Reliability and Efficiency At <?php echo $sitename; ?>, we are proud to offer our esteemed customers exceptional Ocean Freight services. With our unwavering commitment to excellence, we ensure your cargo sails smoothly across the vast seas, reaching its destination in the most efficient and reliable manner.</p>
                                <p>Discover the Power of Ocean Freight: Experience a seamless shipping experience like no other with our Ocean Freight solutions. Whether you are transporting large shipments, oversized cargo, or require cost-effective transportation options, our Ocean Freight services are designed to meet your unique needs.</p>
                                <p>Unparalleled Reliability: At <?php echo $sitename; ?>, we understand that time is of the essence. That's why we meticulously plan every aspect of your Ocean Freight shipment to ensure timely delivery. With our extensive network of trusted carriers, advanced tracking systems, and proactive communication, you can trust us to keep your cargo on schedule, every time.</p>
                                <p>Efficiency Redefined: We take pride in our ability to optimize your Ocean Freight experience for maximum efficiency. Our team of seasoned logistics experts meticulously plans the most efficient routes, negotiates competitive rates, and leverages cutting-edge technologies to streamline the entire shipping process. With <?php echo $sitename; ?>, you can expect reduced transit times, minimized handling, and seamless customs clearance, ensuring your cargo arrives swiftly and intact.</p>
                                <p>Unmatched Customer Satisfaction: Your satisfaction is our paramount priority. Our dedicated team of professionals goes above and beyond to provide personalized support throughout your Ocean Freight journey. From detailed shipment tracking to proactive problem-solving, we are committed to keeping you informed and ensuring a stress-free shipping experience. With <?php echo $sitename; ?>, you can expect exceptional service tailored to your specific requirements.</p>
                                <p>Sweat-Free Shipping Solutions: Forget the worries and hassles associated with Ocean Freight. With <?php echo $sitename; ?>, we take care of every aspect, allowing you to focus on what matters most – your business. Let us handle the logistics intricacies while you enjoy the peace of mind that comes with our reliable, hassle-free shipping solutions.</p>
                                <h4>Experience the Paramount Advantage:</h4>
                                <p>When it comes to Ocean Freight, choose <?php echo $sitename; ?> as your trusted partner. With our unwavering commitment to excellence, unrivaled reliability, and exceptional customer service, we are dedicated to surpassing your expectations. Discover the unparalleled power of our Ocean Freight solutions and embark on a journey of seamless, efficient, and stress-free shipping.</p>
                                <p>Contact us today to experience the paramount difference in Ocean Freight services. Let us take your cargo across the oceans, so you can focus on what you do best – driving your business forward. Trust <?php echo $sitename; ?>, your ultimate courier and logistics partner.</p>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- services-details-end -->


    </main>
    <!-- main-area-end -->

    <?php include 'footer.php'; ?>




    <!-- JS here -->

    <script src="js/vendor/jquery-1.12.4.min.js"></script>
    <script src="js/popper.min.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/isotope.pkgd.min.js"></script>
    <script src="js/slick.min.js"></script>
    <script src="js/jquery.meanmenu.min.js"></script>
    <script src="js/ajax-form.js"></script>
    <script src="js/wow.min.js"></script>
    <script src="js/aos.js"></script>
    <script src="js/paroller.js"></script>
    <script src="js/jquery.waypoints.min.js"></script>
    <script src="js/jquery.counterup.min.js"></script>
    <script src="js/jquery.nice-select.min.js"></script>
    <script src="js/jquery.scrollUp.min.js"></script>
    <script src="js/imagesloaded.pkgd.min.js"></script>
    <script src="js/jquery.magnific-popup.min.js"></script>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCo_pcAdFNbTDCAvMwAD19oRTuEmb9M50c"></script>
    <script src="js/plugins.js"></script>
    <script src="js/main.js"></script>
</body>

<!-- service-air.html  23:59:27 GMT -->

</html>