<?php
include 'db.php';
include 'config.php';
?>
<!doctype html>
<html class="no-js" lang="en">

<!--   23:54:54 GMT -->

<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <title><?php echo $sitename; ?> - <?php echo $site_title; ?></title>


    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta property="og:image" content="uploads/<?php echo $site_logo; ?>">

    <meta name="keywords" content=" <?php echo $sitename; ?> logistics, <?php echo $sitename; ?> transportation logistics, <?php echo $sitename; ?> logistics inc
        , <?php echo $sitename; ?> transportation logistics carrier setup, paramount transportation logistics services llc,uk based logistics companies, logistics companies uk, uk logistics companies
, largest uk logistics companies, <?php echo $sitename; ?> transportation logistics services ,<?php echo $sitename; ?> global logistics, <?php echo $sitename; ?> logistics fayetteville nc, revenant logistics inc paramount ca, <?php echo $sitename; ?> logistics courier, <?php echo $sitename; ?> logistics private limited, <?php echo $sitename; ?> logistics salem va, next generation logistics <?php echo $sitename; ?>,">


    <meta name="description" content="<?php echo $sitename; ?> Logistics is a premier logistics company offering global freight forwarding, transportation, and supply chain solutions. Our reliable and efficient services ensure on-time delivery, customized solutions, and exceptional customer satisfaction. Explore our expertise in international shipping, warehousing, and customs clearance.">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="shortcut icon" type="image/x-icon" href="uploads/<?php echo $site_logo; ?>">
    <!-- Place favicon.ico in the root directory -->

    <!-- CSS here -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/animate.min.css">
    <link rel="stylesheet" href="css/magnific-popup.css">
    <link rel="stylesheet" href="css/fontawesome-all.min.css">
    <link rel="stylesheet" href="css/aos.css">
    <link rel="stylesheet" href="css/nice-select.css">
    <link rel="stylesheet" href="css/flaticon.css">
    <link rel="stylesheet" href="css/meanmenu.css">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/default.css">
    <link rel="stylesheet" href="css/style.css">
    <link rel="stylesheet" href="css/responsive.css">
</head>

<body>

    <?php include 'header.php'; ?>

    <!-- main-area -->
    <main>

        <!-- slider-area -->
        <section class="slider-area">
            <div class="slider-active">
                <div class="single-slider slider-bg d-flex align-items-center">
                    <div class="slider-overlay-bg"></div>
                    <div class="slider-bg-shape"></div>
                    <div class="container">
                        <div class="row justify-content-center">
                            <div class="col-xl-10 col-lg-11">
                                <div class="slider-content text-center">
                                    <h2 data-animation="fadeInUpS" data-delay=".3s">About Us</h2>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </section>
        <!-- slider-area-end -->



        <!-- about-area -->
        <section class="about-area about-bg">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="about-active">
                            <div class="single-about-wrap">
                                <div class="row align-items-center">
                                    <div class="col-lg-6">
                                        <div class="about-img" style="align-items:none;">
                                            <img src="img/images/about_img01.png" alt="img">
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="about-content">
                                            <div class="section-title about-title mb-25">
                                                <h2>Who We Are? 25 years</h2>


                                            </div>
                                            <p>25 years of experience in Logistics services</p>
                                            <p>Welcome to <?php echo $sitename; ?>, a trusted leader in the logistics industry. We specialize in providing comprehensive and customized logistics solutions that drive efficiency and optimize supply chain operations for our valued clients.</p>
                                            <p>At <?php echo $sitename; ?>, we pride ourselves on our unwavering commitment to excellence, reliability, and customer satisfaction. With years of experience in the industry, we have established ourselves as a preferred partner for businesses seeking seamless and cost-effective logistics services.</p>
                                            <p>Our dedicated team of professionals comprises logistics experts who possess in-depth knowledge and expertise in various sectors. We understand that each business has unique requirements, which is why we take a personalized approach to deliver tailored logistics solutions. Whether you need assistance with transportation, warehousing, distribution, or customs clearance, we have the resources and capabilities to handle it all.</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- about-area-end -->

        <!-- section-area -->
        <section class="area-wrapper black-bg position-relative pt-115 pb-120">
            <div class="area-wrap-bg"></div>
            <div class="testimonial-map-bg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="testimonial-area">
                            <div class="section-title white-title mb-55">
                                <h6>Happy Customer Quotes</h6>
                                <h2>Our Top Reviews</h2>
                            </div>
                            <div class="testimonial-active">
                                <div class="single-testimonial">
                                    <div class="testimonial-cat mb-30">
                                        <h5>Shipping Cargo</h5>
                                        <div class="testimonial-rating">
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                        </div>
                                    </div>
                                    <div class="testimonial-content mb-45">
                                        <p>“ I used this cargo delivery service to ship goods internationally, and I was extremely impressed. The process was
                                            seamless, the staff was friendly, and my items arrived on time without damage. Highly recommed! ”</p>
                                    </div>
                                    <div class="testimonial-avatar">
                                        <div class="testi-avatar-img">
                                            <img src="img/images/testi_avatar01.png" alt="img">
                                        </div>
                                        <div class="testi-avatar-info">
                                            <h6>Tony Alexander</h6>
                                            <span>Business person</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="single-testimonial">
                                    <div class="testimonial-cat mb-30">
                                        <h5>Air Freight</h5>
                                        <div class="testimonial-rating">
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                            <i class="fas fa-star"></i>
                                        </div>
                                    </div>
                                    <div class="testimonial-content mb-45">
                                        <p>“ I needed an urgent delivery, and this cargo service exceeded my expectations. Not only did they deliver on time,
                                            but their communication throughout the process was exceptional. Will definitely use their services again.”</p>
                                    </div>
                                    <div class="testimonial-avatar">
                                        <div class="testi-avatar-img">
                                            <img src="img/images/testi_avatar02.png" alt="img">
                                        </div>
                                        <div class="testi-avatar-info">
                                            <h6>Lanu Dexander</h6>
                                            <span>Ecommerce</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!-- section-area-end -->




        <!-- fact-area -->
        <section class="fact-area position-relative pt-115">
            <div class="fact-bg"></div>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-6">
                        <div class="section-title text-center mb-70">
                            <h6>Deliver Anything</h6>
                            <h2>Our Service</h2>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-3 col-lg-4 col-sm-6">
                        <div class="single-fact mb-50">
                            <div class="fact-icon mb-25">
                                <i class="flaticon-package"></i>
                            </div>
                            <div class="fact-content">
                                <!-- <h4><span class="count">3,560</span> km</h4> -->
                                <h6>Road Freight</h6>
                                <p>When it comes to transporting goods, road freight is a versatile and cost-effective solution that offers flexibility and convenience.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-sm-6">
                        <div class="single-fact mb-50">
                            <div class="fact-icon mb-25">
                                <i class="flaticon-placeholder"></i>
                            </div>
                            <div class="fact-content">
                                <!-- <h4><span class="count">195</span></h4> -->
                                <h6>Air Freight</h6>
                                <p>Global Air Freight Network: With an extensive global network of airline partners and agents, we have the capability to handle air freight shipments to and from virtually any destination worldwide.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-sm-6">
                        <div class="single-fact mb-50">
                            <div class="fact-icon mb-25">
                                <i class="flaticon-like"></i>
                            </div>
                            <div class="fact-content">
                                <!-- <h4><span class="count">99</span> Yr</h4> -->
                                <h6>Ocean Freight</h6>
                                <p>When it comes to transporting large quantities of goods across long distances, ocean freight is a trusted and cost-effective solution. At <?php echo $sitename; ?>., we specialize in providing reliable</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-3 col-lg-4 col-sm-6">
                        <div class="single-fact mb-50">
                            <div class="fact-icon mb-25">
                                <i class="flaticon-user"></i>
                            </div>
                            <div class="fact-content">
                                <!-- <h4><span class="count">456</span> k</h4> -->
                                <h6>Packaging & Storage</h6>
                                <p>When it comes to transporting large quantities of goods across long distances, ocean freight is a trusted and cost-effective solution. At <?php echo $sitename; ?>., we specialize in providing reliable</p>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </section>
        <!-- fact-area-end -->

        <?php include 'footer.php'; ?>


        <!-- JS here -->

        <script src="js/vendor/jquery-1.12.4.min.js"></script>
        <script src="js/popper.min.js"></script>
        <script src="js/bootstrap.min.js"></script>
        <script src="js/isotope.pkgd.min.js"></script>
        <script src="js/slick.min.js"></script>
        <script src="js/jquery.meanmenu.min.js"></script>
        <script src="js/ajax-form.js"></script>
        <script src="js/wow.min.js"></script>
        <script src="js/aos.js"></script>
        <script src="js/paroller.js"></script>
        <script src="js/jquery.waypoints.min.js"></script>
        <script src="js/jquery.counterup.min.js"></script>
        <script src="js/jquery.nice-select.min.js"></script>
        <script src="js/jquery.scrollUp.min.js"></script>
        <script src="js/imagesloaded.pkgd.min.js"></script>
        <script src="js/jquery.magnific-popup.min.js"></script>
        <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCo_pcAdFNbTDCAvMwAD19oRTuEmb9M50c"></script>
        <script src="js/plugins.js"></script>
        <script src="js/main.js"></script>
</body>

<!--   23:57:06 GMT -->

</html>